/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.utility.game.server;

import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;
import net.minecraft.class_1267;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;

public final class ServerUtility
implements IMinecraft {
    public static boolean hasCT;
    public static int ctTime;
    public static int ftAn;

    public static boolean isCM() {
        return ServerUtility.is("cherry.pizza");
    }

    public static boolean isST() {
        return ServerUtility.is("spooky");
    }

    public static boolean isFT() {
        return ServerUtility.is("funtime") || ServerUtility.is("playft");
    }

    public static boolean isRW() {
        return ServerUtility.is("reallyworld") || ServerUtility.is("playrw");
    }

    public static boolean isFS() {
        return ServerUtility.is("funsky");
    }

    public static boolean isHW() {
        return ServerUtility.is("holy") || ServerUtility.is("holly") || ServerUtility.is("playhw");
    }

    public static boolean isSunWay() {
        return ServerUtility.is("sunw");
    }

    public static boolean isSaturn() {
        return ServerUtility.is("saturn");
    }

    public static boolean isSR() {
        return ServerUtility.is("sunmc");
    }

    public static boolean isLG() {
        return ServerUtility.is("lonygrief") || ServerUtility.is("lony");
    }

    public static boolean isIntave() {
        return ServerUtility.is("mineblaze") || ServerUtility.is("dexland");
    }

    public static boolean isServerForHPFix() {
        return ServerUtility.isFT() || ServerUtility.isRW() || ServerUtility.isFS();
    }

    public static boolean isPastaFT() {
        return ServerUtility.isFT() || ServerUtility.isST() || ServerUtility.isFS();
    }

    public static String getIP() {
        return ServerUtility.mc.field_1724 != null && ServerUtility.mc.field_1724.field_3944.method_45734() != null ? ServerUtility.mc.field_1724.field_3944.method_45734().field_3761 : "single";
    }

    public static boolean is(String ip) {
        return ServerUtility.getIP().toLowerCase().contains(ip.toLowerCase());
    }

    public static String getServerName(boolean shortName) {
        String ip = ServerUtility.getIP();
        String[] parts = ip.split("\\.");
        if (mc.method_1542()) {
            return ServerUtility.applyCase(ip, shortName);
        }
        if (parts.length == 3) {
            return ServerUtility.applyCase(parts[1], shortName);
        }
        if (parts.length == 2) {
            return ServerUtility.applyCase(parts[0], shortName);
        }
        return ip.contains(":") ? ip.split(":")[0] : ip;
    }

    private static String applyCase(String server, boolean shortName) {
        server = ((String)server).replace("-", "");
        ArrayList datas = new ArrayList();
        String[] suffixes = new String[]{"legacy", "bars", "world", "best", "times", "time", "shine", "sky", "lands", "land", "trainer", "server", "blaze", "mine", "lord", "cube", "grief", "craft", "rise", "force", "project", "lite"};
        Arrays.stream(suffixes).forEach(suffix -> datas.add(ServerUtility.genData(suffix)));
        Arrays.stream(new Data[]{new Data("mc", "MC", "-MC"), new Data("hvh", "HVH", "-HVH"), new Data("pvp", "PVP", "PVP")}).forEach(datas::add);
        if (mc.method_1542() && !shortName) {
            server = "LocalHost";
        }
        if (ServerUtility.isSR()) {
            Object object = server = shortName ? "SR" : "SunRise";
        }
        if (ServerUtility.isSaturn()) {
            Object object = server = shortName ? "S-X" : "SaturnX";
        }
        if (ServerUtility.isSunWay()) {
            server = shortName ? "SW" : "SunWay";
        }
        for (Data data : datas) {
            if (!((String)server).contains(data.orig)) continue;
            if (shortName) {
                server = ((String)server).substring(0, 1).toUpperCase() + data.small;
            } else {
                server = ((String)server).replace(data.orig, data.big);
                server = ((String)server).substring(0, 1).toUpperCase() + ((String)server).substring(1);
            }
            return server;
        }
        return ((String)server).substring(0, 1).toUpperCase() + ((String)server).substring(1);
    }

    public static boolean spawn() {
        if (ServerUtility.mc.field_1724 != null && ServerUtility.mc.field_1687 != null) {
            class_2338 pos = ServerUtility.mc.field_1724.method_24515();
            class_2248 blockBelow = ServerUtility.mc.field_1687.method_8320(pos.method_10087(1)).method_26204();
            class_2248 blockAtZero = ServerUtility.mc.field_1687.method_8320(new class_2338(pos.method_10263(), 0, pos.method_10260())).method_26204();
            if (ServerUtility.isFT() && ServerUtility.mc.field_1687.method_8407() == class_1267.field_5802) {
                return false;
            }
            if (!ServerUtility.isFT() && !ServerUtility.isST()) {
                return ServerUtility.mc.field_1687.method_27983() != class_1937.field_25179 ? false : blockAtZero == class_2246.field_9987 || blockBelow == class_2246.field_9987;
            }
            return blockBelow == class_2246.field_10124 || blockAtZero == class_2246.field_10124;
        }
        return false;
    }

    private static Data genData(String full) {
        return new Data(full, full.substring(0, 1).toUpperCase() + full.substring(1), full.substring(0, 1).toUpperCase());
    }

    @Generated
    private ServerUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static void setHasCT(boolean hasCT) {
        ServerUtility.hasCT = hasCT;
    }

    @Generated
    public static void setCtTime(int ctTime) {
        ServerUtility.ctTime = ctTime;
    }

    static {
        ftAn = -1;
    }

    record Data(String orig, String big, String small) {
    }
}

